class LMSmut extends Mutator;

var bool Init;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	settimer(1.0, true);
}

function Timer()
{
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.Health == 1 && !P.PlayerReplicationInfo.bIsSpectator )
			{
			P.TakeDamage(1, None, P.Location, vect(0,0,0), 'Fell');
			P.ClientMessage(P.PlayerReplicationInfo.PlayerName$" died from failing to cause damage upon enemy!", 'Pickup');
			P.PlaySound(Sound'UnrealShare.Gibs.Gib1',,2.0);
			}
		else if ( !P.PlayerReplicationInfo.bIsSpectator )
			P.Health--;
		if ( P.Health < 0 )
			P.Health = 0;
		}
	
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int CurrentHealth, OldHealth;


	if ( Victim == InstigatedBy || Victim == None || InstigatedBy == None)
		Return;

	OldHealth = InstigatedBy.Health;
	CurrentHealth = Victim.Health;

	if ( ActualDamage > CurrentHealth )
		{
		InstigatedBy.Health += CurrentHealth;
		}
	else
		{
		InstigatedBy.Health += ActualDamage;
		}
	if ( InstigatedBy.Health > 200 )
		{
		InstigatedBy.Health = 200;
		}

	Super.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);

	if ( NextDamageMutator != None )
		{
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
		}

	
}

defaultproperties
{
}
